/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.regex.result.RegexResult;

@ExportLibrary(value=InteropLibrary.class)
public final class SingleResult
extends RegexResult {
    private final int start;
    private final int end;

    public SingleResult(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public int getStart(int groupNumber) {
        return groupNumber == 0 ? this.start : -1;
    }

    @Override
    public int getEnd(int groupNumber) {
        return groupNumber == 0 ? this.end : -1;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects) {
        return "TRegexResult" + this.toString();
    }
}

